﻿//////////////////////////////////////////////
// ThreadPool.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkTasks
{
	class Thread ;

	struct ThreadPoolInfo ;
}

/// Includes ---------------------------------

// nkTasks
#include "../Dll/DllDefines.h"

#include "../Tasks/Task.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkTasks
{
	class DLL_TASKS_EXPORT ThreadPool final
	{
		public :
		
			// Constructor, destructor
			ThreadPool (unsigned int threadCount = 0) noexcept ;
			~ThreadPool () ;

			// Getters
			unsigned int getThreadCount () const ;
			Thread* getThread (unsigned int index) const ;

			// Tasks
			void addTask (nkMemory::UniquePtr<Task> task) ;
			void cancelPendingTasks () ;

			// Threads
			void flush () ;
			void resizeForThreadCount (unsigned int threadCount) ;

		private :
		
			// Attributes
			nkMemory::UniquePtr<ThreadPoolInfo> _poolInfo ;
	} ;
}